/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.goosikconfig.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import ru.pinkgoosik.goosikconfig.impl.AbstractConfig;
import ru.pinkgoosik.goosikconfig.impl.ConfigGenerator;
import ru.pinkgoosik.goosikconfig.impl.parameter.BooleanParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.IntegerParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.StringParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.StringsArrayParameter;

public class JsonToConfig {
    public static AbstractConfig convert(JsonObject object, AbstractConfig config) {
        JsonElement element;
        AbstractConfig newConfig = new AbstractConfig(config.getName());
        boolean needsRegen = false;
        for (BooleanParameter booleanParameter : config.getBooleans()) {
            if (!booleanParameter.getGroup().isBlank()) continue;
            element = object.get(booleanParameter.getName());
            if (element != null && element.isJsonPrimitive()) {
                try {
                    newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), element.getAsBoolean());
                }
                catch (ClassCastException e) {
                    newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), (Boolean)booleanParameter.getValue());
                    needsRegen = true;
                }
                continue;
            }
            newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), (Boolean)booleanParameter.getValue());
            needsRegen = true;
        }
        for (IntegerParameter integerParameter : config.getIntegers()) {
            if (!integerParameter.getGroup().isBlank()) continue;
            element = object.get(integerParameter.getName());
            if (element != null && element.isJsonPrimitive()) {
                try {
                    newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), element.getAsInt());
                }
                catch (ClassCastException e) {
                    newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), (Integer)integerParameter.getValue());
                    needsRegen = true;
                }
                continue;
            }
            newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), (Integer)integerParameter.getValue());
            needsRegen = true;
        }
        for (StringParameter stringParameter : config.getStrings()) {
            if (!stringParameter.getGroup().isBlank()) continue;
            element = object.get(stringParameter.getName());
            if (element != null && element.isJsonPrimitive()) {
                try {
                    newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), element.getAsString());
                }
                catch (ClassCastException e) {
                    newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), (String)stringParameter.getValue());
                    needsRegen = true;
                }
                continue;
            }
            newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), (String)stringParameter.getValue());
            needsRegen = true;
        }
        for (StringsArrayParameter stringsArrayParameter : config.getStringsArrays()) {
            if (!stringsArrayParameter.getGroup().isBlank()) continue;
            element = object.get(stringsArrayParameter.getName());
            if (element != null && element.isJsonArray()) {
                try {
                    JsonArray array = object.get(stringsArrayParameter.getName()).getAsJsonArray();
                    ArrayList<String> strings = new ArrayList<String>();
                    array.forEach(elm -> strings.add(elm.getAsString()));
                    newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), strings);
                }
                catch (ClassCastException e) {
                    newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), (ArrayList)stringsArrayParameter.getValue());
                    needsRegen = true;
                }
                continue;
            }
            newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), (ArrayList)stringsArrayParameter.getValue());
            needsRegen = true;
        }
        for (String string : config.getGroups()) {
            JsonElement groupElement = object.get(string);
            if (groupElement != null && groupElement.isJsonObject()) {
                JsonElement element2;
                JsonObject groupObject = groupElement.getAsJsonObject();
                for (BooleanParameter booleanParameter : config.getBooleans()) {
                    if (!booleanParameter.getGroup().equals(string)) continue;
                    JsonElement element22 = groupObject.get(booleanParameter.getName());
                    if (element22 != null && element22.isJsonPrimitive()) {
                        try {
                            newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), element22.getAsBoolean());
                        }
                        catch (ClassCastException e) {
                            newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), (Boolean)booleanParameter.getValue());
                            needsRegen = true;
                        }
                        continue;
                    }
                    newConfig.addBoolean(booleanParameter.getName(), booleanParameter.getGroup(), (Boolean)booleanParameter.getValue());
                    needsRegen = true;
                }
                for (IntegerParameter integerParameter : config.getIntegers()) {
                    if (!integerParameter.getGroup().equals(string)) continue;
                    element2 = groupObject.get(integerParameter.getName());
                    if (element2 != null && element2.isJsonPrimitive()) {
                        try {
                            newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), element2.getAsInt());
                        }
                        catch (ClassCastException e) {
                            newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), (Integer)integerParameter.getValue());
                            needsRegen = true;
                        }
                        continue;
                    }
                    newConfig.addInteger(integerParameter.getName(), integerParameter.getGroup(), (Integer)integerParameter.getValue());
                    needsRegen = true;
                }
                for (StringParameter stringParameter : config.getStrings()) {
                    if (!stringParameter.getGroup().equals(string)) continue;
                    element2 = groupObject.get(stringParameter.getName());
                    if (element2 != null && element2.isJsonPrimitive()) {
                        try {
                            newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), element2.getAsString());
                        }
                        catch (ClassCastException e) {
                            newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), (String)stringParameter.getValue());
                            needsRegen = true;
                        }
                        continue;
                    }
                    newConfig.addString(stringParameter.getName(), stringParameter.getGroup(), (String)stringParameter.getValue());
                    needsRegen = true;
                }
                for (StringsArrayParameter stringsArrayParameter : config.getStringsArrays()) {
                    if (!stringsArrayParameter.getGroup().equals(string)) continue;
                    element2 = groupObject.get(stringsArrayParameter.getName());
                    if (element2 != null && element2.isJsonArray()) {
                        try {
                            JsonArray array = element2.getAsJsonArray();
                            ArrayList<String> strings = new ArrayList<String>();
                            array.forEach(elm -> strings.add(elm.getAsString()));
                            newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), strings);
                        }
                        catch (ClassCastException e) {
                            newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), (ArrayList)stringsArrayParameter.getValue());
                            needsRegen = true;
                        }
                        continue;
                    }
                    newConfig.addStringsArray(stringsArrayParameter.getName(), stringsArrayParameter.getGroup(), (ArrayList)stringsArrayParameter.getValue());
                    needsRegen = true;
                }
                continue;
            }
            config.getBooleans().forEach(parameter -> {
                if (parameter.getGroup().equals(group)) {
                    newConfig.addBoolean(parameter.getName(), parameter.getGroup(), (Boolean)parameter.getValue());
                }
            });
            config.getIntegers().forEach(parameter -> {
                if (parameter.getGroup().equals(group)) {
                    newConfig.addInteger(parameter.getName(), parameter.getGroup(), (Integer)parameter.getValue());
                }
            });
            config.getStrings().forEach(parameter -> {
                if (parameter.getGroup().equals(group)) {
                    newConfig.addString(parameter.getName(), parameter.getGroup(), (String)parameter.getValue());
                }
            });
            config.getStringsArrays().forEach(parameter -> {
                if (parameter.getGroup().equals(group)) {
                    newConfig.addStringsArray(parameter.getName(), parameter.getGroup(), (ArrayList)parameter.getValue());
                }
            });
            needsRegen = true;
        }
        if (needsRegen) {
            ConfigGenerator.generate(newConfig);
        }
        return newConfig;
    }
}

